{{
import datetime
import malcat


def pval(key, val=None, fmt="{}", va=False, fa=False, rva=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            toprint = val.value
            if type(toprint) == str:
                toprint = toprint.replace("[", "\\[")
            elif type(toprint) ==  datetime.datetime:
                toprint = toprint.strftime("%Y-%m-%d %H:%M:%S")
            d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

}}
[color1]UImage Header[/color1]
  {{pval("Architecture", analysis.struct.Header.Architecture, valign=24)}} {{pval("Operating System", analysis.struct.Header.OsType)}}
  {{pval("Compression method", analysis.struct.Header.CompressionType, valign=24)}} {{pval("Compressed size", analysis.struct.Header.ImageSize)}}

  {{pval("Load address", analysis.struct.Header.LoadAddress, "{:x}", va=True, valign=24)}} {{pval("Entry address", analysis.struct.Header.EntryAddress, "{:x}", va=True)}}

  {{pval("Creation date", analysis.struct.Header.Timestamp, valign=24)}}

  {{pval("Image name", analysis.struct.Header.Name)}}
 
