{{
import malcat
import datetime
from filetypes.ONE import FileChunkReference


def pval(key, val=None, fmt="{}", va=False, fa=False, rva=False, kalign=30, valign=0, formated=False):
    r = ""
    if key:
        r = "[normal]{}[/normal]:".format(key)
        lr = len(r) - 17
        if lr < kalign:
            r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        grp = "normal"
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
        elif isinstance(val, datetime.datetime):
            if val.year <= 1970:
                grp = "dim"
            d = val.strftime("%Y-%m-%d %H:%M")
            ld = len(d)
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

def sections_rights(rights):
    s = ""
    for e in [
        ("MemRead", "R"),
        ("MemWrite", "W"),
        ("MemExecute", "X"),
        ("ScnAlign1", "1"),
        ("ScnAlign2", "2"),
        ("ScnAlign8", "8"),
        ("MemShared", "S"),
        ("MemNotPaged", "P"),
        ("MemNotCached", "H"),
        ("MemDiscardable", "D"),
        ("SctCntCode", "C"),
        ("SctCntInitializedData", "I"),
        ("SctCntUnititializedData", "U"),
        ]:
        if rights[e[0]]:
            s += "[color5]{}[/color5]".format(e[1])
        else:
            s += "[dim]∙[/dim]"
    return s

}}
[color1]Header[/color1] 
  {{ pval("File ID", analysis.struct.Header.File, valign=24) }} 
  {{ pval("Last Application", analysis.struct.Header.LastCodeThatWroteToThisFile, valign=24) }} {{ pval("Last Application Version", analysis.struct.Header.NewestWritten, "{:x}") }}

{{ if "DataStore" in analysis.struct:}} 
[color1]Embedded Files[/color1] 
{{ for e in analysis.struct.DataStore[1:-1]:}}
{{
    if e.name != "FileDataStoreObjectReferenceFND":
        continue
    if "SizeCompressed" in e["FileChunkReferenceWithGuid"]:
        offset, size = FileChunkReference.unpack(e["FileChunkReferenceWithGuid"])
}}
  [color3]{{"{" + e["FileChunkReferenceWithGuid"]["Guid"] +"}"}} [/color3]
  {{ pval("Offset", offset, "{:08x}", fa=True, valign=24) }} {{ pval("Size", size, "{} bytes") }}

{{:endfor}}
{{:endif}}
