{{
import datetime
import malcat


def pval(key, val=None, fmt="{}", va=False, fa=False, rva=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            toprint = val.value
            if type(toprint) == str:
                toprint = toprint.replace("[", "\\[")
            elif type(toprint) ==  datetime.datetime:
                toprint = toprint.strftime("%Y-%m-%d %H:%M:%S")
            d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

num_files_displayed = 0
}}
[color1]JFFS2 file system[/color1]
{{ for name, inodes in analysis.parser.filesystem.items(): }}
{{ inode = inodes[0] }} 
    ● [color2]{{ write(name.replace("[", "\\["))}}[/color2]
        {{ pval("File size", inode.Size, "{:d} bytes", kalign=28, valign=24) }} {{ pval("Version", inode.Version) }}
        {{ pval("User id", inode.Uid, kalign=28, valign=24) }} {{ pval("Group id", inode["Gid"]) }}
        {{ pval("Created", inode.CreatedTime, kalign=28, valign=24) }} {{ pval("Accessed", inode.AccessTime) }}
        {{ pval("Modified", inode.ModifiedTime, kalign=28, valign=24) }} 

{{
if num_files_displayed > 128:
    write("[block1] ... and more ...[/block1]")
    break
num_files_displayed += 1
}}
{{ :endfor }}
