{{
import datetime
import malcat



def pval(key, val=None, fmt="{}", va=False, fa=False, rva=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            toprint = val.value
            if type(toprint) == str:
                toprint = toprint.replace("[", "\\[")
            d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"  
        elif type(val) == bool:
            if val:
                grp = "color1"
            else:
                grp = "dim"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  


def pstring(s):
    if s is None:
        return "[dim]-[/dim]"
    elif type(s) == bytes:
        s = s.decode("ascii", errors="backslashreplace")
    return s.replace("[", "\\[")
}}

[color1]Archive[/color1]
    {{ pval("Inno version", pstring(analysis.struct["InnoHeader"]["Identifier"]), valign=24) }} 
    {{ pval("Guessed password", pstring(analysis.parser.guessed_password), valign=24) }} 

[color1]Files[/color1]
{{ for f in analysis.parser.filesystem.values(): }}
    [vfile]{{ write(pstring(f.path)) }}[/vfile]
        {{ pval("Offset", f.offset, fmt="{:x}", valign=24, kalign=28) }} {{ pval("Size", f.size, fmt="{:d} bytes", valign=24, kalign=28) }}
        {{ pval("Chunk offset", f.chunk_offset, fmt="{:x}", fa=True, valign=24, kalign=28) }} {{ pval("Chunk size", f.chunk_size, fmt="{:d} bytes", valign=24, kalign=28) }}
        {{ pval("Encrypted", f.encrypted, valign=24, kalign=28) }} {{ pval("Filtered", f.filtered, valign=24, kalign=28) }}

{{ :endfor}}
