{{

def pval(key, val="", fmt="{}", va=False, rva=False, kalign=30, valign=0):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))

    d = fmt.format(val)
    if type(val) == int: 
        if val == 0:
            grp = "dim"
        elif rva:
            grp = "rva"
        elif va:
            grp = "va"
        else:
            grp = "normal"
    else:
        grp = "normal"
    d = "[{}]{}[/{}]".format(grp,d,grp)
    ld = len(d) - (5+len(grp) * 2)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  
}}

[color1]Icon header[/color1]
  {{ pval("Type", analysis.struct["IconDirectory"]["Type"], "{:04x}") }} (Icon)
  {{ pval("Number of icons", analysis.struct["IconDirectory"]["NumberOfItems"], "{:04x}") }}

[color1]List of items[/color1]
{{ for i in range(analysis.struct["Items"].count): }} {{ item = analysis.struct["Items"][i] }}
  - [color3]Item{{i}}[/color3]
       * Type:                  {{ if "Item.{}.BMP.BitmapInfoHeader".format(i) in analysis.struct:}}BMP{{:elif "Item.{}.PNG.IHDR".format(i) in analysis.struct:}}PNG{{:else:}}Unknown{{:end}}
       * Offset:                [fa]{{ "{:08x}".format(analysis.struct["Items"][i]["Offset"],)}}[/fa]
       * Size:                  {{analysis.struct["Items"][i]["Size"]}} bytes
       * Dimensions:            {{analysis.struct["Items"][i]["Width"]}}x{{analysis.struct["Items"][i]["Height"]}} pixels
       * Number of colors:      {{analysis.struct["Items"][i]["NumberOfColors"]}} ({{analysis.struct["Items"][i]["Bpp"]}} bpp)
{{ :end }}

