{{
import datetime
import malcat

def pval(key, val=None, fmt="{}", fa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))

}}
[color1]GZIP Header[/color1]
  {{pval("Compression method", analysis.struct.GzipHeader.Compression, valign=20)}} {{pval("Operating System", analysis.struct.GzipHeader.OperatingSystem)}}
  {{pval("Modification time", analysis.struct.GzipHeader.ModificationTime.value.strftime('%Y-%m-%d %H:%M'), valign=20)}} {{pbitfield("Flags", analysis.struct.GzipHeader.Flags)}}
{{ if "FileName" in analysis.struct.GzipHeader: }}
  {{pval("Compression method", analysis.struct.GzipHeader.FileName, valign=20)}}
{{:endif}}
