{{
import datetime
import malcat

def pval(key, val=None, fmt="{}", fa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        elif isinstance(val.value, datetime.datetime):
            d = val.value.strftime("%Y-%m-%d %H:%M")
            ld = len(d)
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif fa:
                grp = "fa"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  
}}
[color1]Cobalt Strike configuration file[/color1]

{{ for s in analysis.struct["CobaltHeader"]: }}
{{ index = s["Index"] }}
{{ if "Value" in s and type(s["Value"]) in (int, str): }}
{{ pval(s.name, s.Value, kalign=36) }}

{{ if index in (51,): }}
{{ for value_index in range(4, s.count): }}
{{ element = s.at(value_index)}}
{{ if element.name == "Value" and element.enum:}}
                                    [color6]{{element.enum}}[/color6]([dim]{{element.value}}[/dim])
{{ :endif}}
{{:endfor}}
{{ :endif}}
{{ :endif}}
{{:endfor}}

[dim]/!\ Note that just the most important fields are printed there, go to the structure view for more detailed information[/dim]
