{{
import datetime
import malcat

def pval(key, val=None, fmt="{}", pa=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            d = fmt.format(val.value)
            ld = len(d)
        val = val.value
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        grp = "normal"
        if type(val) == int: 
            if pa:
                grp = "fa"
            elif val == 0:
                grp = "dim"
            else:
                grp = "normal"
        elif isinstance(val, datetime.datetime):
            if val.year <= 1980:
                grp = "dim"
            d = val.strftime("%Y-%m-%d %H:%M")
            ld = len(d)
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))
}}


[color1]Header[/color1]
  {{ pval("Version", analysis.struct.ChmHeader.Version, valign=24) }} {{ pval("Language", analysis.struct.ChmHeader.Language) }}

[color1]Files[/color1]
{{ for chunk in analysis.struct["ListingChunks"]: }}
{{ for entry in chunk["Entries"][1:]: }}
  [color2]{{write(entry["Name"].replace("[", "\\["))}}[/color2]
    {{ pval("In section", entry["SectionId"], "#{:d}", kalign=28, valign=24) }} {{ pval("Offset", entry["Offset"], "#{:08x}") }}
    {{ pval("File size", entry["Size"], "{:d} bytes", kalign=28, valign=24) }} {{ pval("Compressed", entry["SectionId"] and "Yes" or "No") }}

{{:endfor}}
{{:endfor}}
