{{
import datetime
import malcat
from helpers import naturalsize

def pval(key, val=None, fmt="{}", va=False, pa=False, rva=False, size=False, kalign=30, valign=0, formated=False):
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    if isinstance(val, malcat.StructAccess) or isinstance(val, malcat.FieldAccess):
        if val.has_enum and val.enum:
            d = "[color6]{}[/color6]([dim]{}[/dim])".format(val.enum, fmt.format(val.value))
            formated = True
            ld = len(d) - len("[color3][/color3][dim][/dim]")
        else:
            if size:
                d = naturalsize(val.value, binary=True)
            else:
                toprint = val.value
                if type(toprint) == str:
                    toprint = toprint.replace("[", "\\[")
                d = fmt.format(toprint)
            ld = len(d)
        val = val.value
    elif size and type(val) == int:
        d = naturalsize(val, binary=True)
        ld = len(d)
    else:
        d = fmt.format(val)
        ld = len(d)
    if not formated:
        if type(val) == int: 
            if val == 0:
                grp = "dim"
            elif pa:
                grp = "fa"
            elif rva:
                grp = "rva"
            elif va:
                grp = "va"
            else:
                grp = "normal"
        else:
            grp = "normal"
        d = "[{}]{}[/{}]".format(grp,d,grp)
    if ld < valign:
        d += (" "*(valign-ld))
    write(r+d)  

def bitfieldpp(fa):
    s = []
    for i in range(fa.count - 1, -1, -1):
        bit = fa.at(i)
        if bit.value:
            s.append("[color5]{}[/color5]([dim]{:X}[/dim])".format(bit.name, 1 << i))
    if s:
        return  " + ".join(s)
    else:
        return "[dim]0[/dim]"

def pbitfield(key, fa, kalign=30):    
    r = "[normal]{}[/normal]:".format(key)
    lr = len(r) - 17
    if lr < kalign:
        r += (" "*(kalign-lr))
    write(r + bitfieldpp(fa))
}}

[color1]CFHeader[/color1]
  {{ pval("Archive size", analysis.struct.CFHeader.Size, size=True, valign=24) }} {{ pval("FirstFile", analysis.struct.CFHeader.FirstFile, "{:x}", pa=True, valign=24) }}
  {{ pval("Version", "{}.{}".format(analysis.struct["CFHeader"]["VersionMajor"], analysis.struct["CFHeader"]["VersionMinor"]), valign=24) }} {{ pbitfield("Flags", analysis.struct.CFHeader.Flags) }}
  {{ pval("NumberOfFolders", analysis.struct.CFHeader.NumberOfFolders, "{:d}", valign=24) }} {{ pval("NumberOfFiles", analysis.struct.CFHeader.NumberOfFiles, "{:d}", valign=24) }}
  {{ pval("SetId", analysis.struct.CFHeader.SetId, "{:d}", valign=24) }} {{ pval("iCabinet", analysis.struct.CFHeader.iCabinet, "{:d}", valign=24) }}

[color1]Files[/color1]
{{for f in analysis.struct: }}
{{if f.name == "CFFile":}} 
  [vfile]{{f["FileName"]}}[/vfile]
     {{ pval("File size", naturalsize(f["UncompressedSize"], binary=True), kalign=28, valign=24) }} {{ pval("Last Modification", "{} {}".format(f["Date"], f["Time"]), valign=24) }}
     {{ pbitfield("Attributes", f["Attributes"], kalign=28) }}
{{:endif}}
{{:endfor}}
