"""
name: Lumma Stealer
category: config extractors
author: malcat

Decrypt CnC urls from a (unpacked) lumma stealer sample
"""
import base64
import malcat
malcat.setup()  # Add Malcat's data directories to sys.path when called in headless mode
from transforms.binary import CircularXor

############################ config extraction

def lumma_stealer_decrypt_config(a):
    for s in a.strings:
        if s.tag == "BASE64":
            data = base64.b64decode(s.text)
            if len(s) > 32:
                try:
                    yield CircularXor().run(data[32:], key=data[:32]).decode("ascii")
                except: pass

################################ MAIN
    
if __name__ == "__main__":

    cncs = []
    if "analysis" in globals():
        # called from the gui, analysis object is already instanciated with the current file
        cncs.extend(lumma_stealer_decrypt_config(analysis))
    else:
        # called in headless mode, we need to analyse a file first
        import optparse
        usage = "usage: %prog <file1> [file2] ... [fileN]"
        parser = optparse.OptionParser(usage=usage, description="""Extract config for (unpacked) Lummastealer samples""")
        options, args = parser.parse_args()
        if len(args) < 1:
            parser.error("Please give path to a file")

        for fname in args:
            a = malcat.analyse(fname)
            cncs.extend(lumma_stealer_decrypt_config(a))

    for cnc in cncs:
        print(cnc)
