"""
name: Byte cells decode (XLS) 
category: office
filetype: Office.Workbook8
author: malcat
icon: wxART_FIND_HEX

Converts all cells (in all sheets) containing a 0-255 number to bytes and open the resulting bytearray. Works for Office97 workbooks.

Sometimes malware authors like to encode their payload as uint8 numbers in excel cells. This is a quick way to retrieve the payload.
"""
import malcat

res = bytearray()
for sheet in analysis.parser.sheets[1:]:
    for cell, val in sheet.values.items():
        if type(val) == float and val < 256:
            res.append(int(val) & 0xff)
gui.open_after(bytes(res), "cell values")
