"""
name: DIB to BMP
category: image
filetype: DIB
author: malcat
icon: wxART_FILETYPE_IMAGE

Convert a Device Independant Bitmap (which is a header-less BMP) to a full-fledged BMP file by prepending a BMP header. Useful to export embedded DIBs.
"""
import struct 

BITMAP_FILE_HEADER_SIZE = 0xe
data = analysis.file[:]
fake_header = struct.pack("<2sIII", b"BM", len(data) + BITMAP_FILE_HEADER_SIZE, 0, BITMAP_FILE_HEADER_SIZE + analysis.struct.at("biImageData").offset )

gui.open_after(fake_header + data, "bmp")
