from filetypes.Golang import parse_golang_structures



def parse_golang(macho):

    yield from parse_golang_structures(macho, 
            is64 = macho.is64,
            va2off = macho.va2off,
            off2va = macho.off2va)
    
    # build id
    gometadata = {}

    if "GO.PcLnFunctionInfoPointers" in macho:
        fnpointers = macho["GO.PcLnFunctionInfoPointers"]
        # get go build id
        if fnpointers.count:
            off = macho.va2off(fnpointers[0]["FunctionStartAddress"])
            if off:
                buildid = macho.read_cstring_ascii(off + 16)
                macho.add_metadata("BuildID", buildid[:buildid.find("\"")], category="Golang")

    
