from filetypes.base import *
import malcat 


class Header(Struct):

    def parse(self):
        yield String(6, name="Magic")
        version = yield UInt8(name="Version")
        yield UInt8(name="Architecture", values=[
            ("ARCH_386", 0),
            ("ARCH_Z80", 1),
            ("ARCH_I860", 2),
            ("ARCH_8051", 3),
            ("ARCH_TMS", 4),
            ("ARCH_6502", 5),
            ("ARCH_PDP", 6),
            ("ARCH_68K", 7),
            ("ARCH_JAVA", 8),
            ("ARCH_6800", 9),
            ("ARCH_ST7", 10),
            ("ARCH_MC6812", 11),
            ("ARCH_MIPS", 12),
            ("ARCH_ARM", 13),
            ("ARCH_TMSC6", 14),
            ("ARCH_PPC", 15),
            ("ARCH_80196", 16),
            ("ARCH_Z8", 17),
            ("ARCH_SH", 18),
            ("ARCH_NET", 19),
            ("ARCH_AVR", 20),
            ("ARCH_H8", 21),
            ("ARCH_PIC", 22),
            ("ARCH_SPARC", 23),
            ("ARCH_ALPHA", 24),
            ("ARCH_HPPA", 25),
            ("ARCH_H8500", 26),
            ("ARCH_TRICORE", 27),
            ("ARCH_DSP56K", 28),
            ("ARCH_C166", 29),
            ("ARCH_ST20", 30),
            ("ARCH_IA64", 31),
            ("ARCH_I960", 32),
            ("ARCH_F2MC", 33),
            ("ARCH_TMS320C54", 34),
            ("ARCH_TMS320C55", 35),
            ("ARCH_TRIMEDIA", 36),
            ("ARCH_M32R", 37),
            ("ARCH_NEC_78K0", 38),
            ("ARCH_NEC_78K0S", 39),
            ("ARCH_M740", 40),
            ("ARCH_M7700", 41),
            ("ARCH_ST9", 42),
            ("ARCH_FR", 43),
            ("ARCH_MC6816", 44),
            ("ARCH_M7900", 45),
            ("ARCH_TMS320C3", 46),
            ("ARCH_KR1878", 47),
            ("ARCH_AD218X", 48),
            ("ARCH_OAKDSP", 49),
            ("ARCH_TLCS900", 50),
            ("ARCH_C39", 51),
            ("ARCH_CR16", 52),
            ("ARCH_MN102L00", 53),
            ("ARCH_TMS320C1X", 54),
            ("ARCH_NEC_V850X", 55),
            ("ARCH_SCR_ADPT", 56),
            ("ARCH_EBC", 57),
            ("ARCH_MSP430", 58),
            ("ARCH_SPU", 59),
            ("ARCH_DALVIK", 60),
        ])
        yield BitsField(
            Bit(name="DOS_EXE_OLD"),
            Bit(name="DOS_COM_OLD"),
            Bit(name="BIN"),
            Bit(name="DOSDRV"),
            Bit(name="NE"),
            Bit(name="INTEL_HEX"),
            Bit(name="MOS_HEX"),
            Bit(name="LX"),
            Bit(name="LE"),
            Bit(name="NLM"),
            Bit(name="COFF"),
            Bit(name="PE"),
            Bit(name="OMF"),
            Bit(name="SREC"),
            Bit(name="ZIP"),
            Bit(name="OMFLIB"),
            Bit(name="AR"),
            Bit(name="LOADER"),
            Bit(name="ELF"),
            Bit(name="W32RUN"),
            Bit(name="AOUT"),
            Bit(name="PILOT"),
            Bit(name="DOS_EXE"),
            Bit(name="DOS_COM"),
            Bit(name="AIXAR"),
            name="Filetypes", comment="supported file types")
        yield BitsField(
            Bit(name="MSDOS"),
            Bit(name="WIN"),
            Bit(name="OS2"),
            Bit(name="NETWARE"),
            Bit(name="UNIX"),
            Bit(name="OTHER"),
            NullBits(10),
            name="OperatingSystem", comment="supported operating system")
        yield BitsField(
            Bit(name="CONSOLE"),
            Bit(name="GRAPHICS"),
            Bit(name="EXE"),
            Bit(name="DLL"),
            Bit(name="DRV"),
            Bit(name="SINGLE_THREADED"),
            Bit(name="MULTI_THREADED"),
            Bit(name="16Bits"),
            Bit(name="32Bits"),
            Bit(name="64Bits"),
            name="ApplicationType", comment="supported applications")
        yield BitsField(
            Bit(name="STARTUP"),
            Bit(name="CTYPE_CRC"),
            Bit(name="2BYTES_CTYPE"),
            Bit(name="ALT_TYPE_CRC"),
            Bit(name="COMPRESSED"),
            NullBits(11),
            name="Features", comment="features")
        if version < 6:
            yield UInt16(name="NumberOfFunctions")
        else:
            yield Unused(2)
        yield UInt16(name="Crc16")
        yield Bytes(12, name="Ctype")
        lnsz = yield UInt8(name="LibraryNameSize")
        yield UInt16(name="CtypesCrc16")
        if version >= 6:
            yield UInt32(name="NumberOfFunctions")
        if version >= 8:
            yield UInt16(name="PatternSize")
        if version >= 10:
            yield Unused(2)
        if lnsz:
            yield String(lnsz, name="LibraryName")



        


class FlirtAnalyzer(FileTypeAnalyzer):
    category = malcat.FileType.DOCUMENT
    name = "FLIRT"
    regexp = r"IDASGN[\x05-\x20][\x00-\x60]"


    def parse(self, hint):
        hdr = yield Header()
        self.confirm()
